/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.ingredients.RegisteredIngredients;
import mezz.jei.ingredients.TypedIngredient;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IRecipeFocusSource;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GuiContainerWrapper
implements IRecipeFocusSource {
    private final RegisteredIngredients registeredIngredients;
    private final GuiScreenHelper guiScreenHelper;

    public GuiContainerWrapper(RegisteredIngredients registeredIngredients, GuiScreenHelper guiScreenHelper) {
        this.registeredIngredients = registeredIngredients;
        this.guiScreenHelper = guiScreenHelper;
    }

    @Override
    public Stream<IClickedIngredient<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        Screen guiScreen = Minecraft.m_91087_().f_91080_;
        if (!(guiScreen instanceof AbstractContainerScreen)) {
            return Stream.empty();
        }
        AbstractContainerScreen guiContainer = (AbstractContainerScreen)guiScreen;
        return Stream.concat(this.guiScreenHelper.getPluginsIngredientUnderMouse(guiContainer, mouseX, mouseY), this.getSlotIngredientUnderMouse(guiContainer).stream());
    }

    private Optional<IClickedIngredient<?>> getSlotIngredientUnderMouse(AbstractContainerScreen<?> guiContainer) {
        return Optional.ofNullable(guiContainer.getSlotUnderMouse()).flatMap(slot -> this.getClickedIngredient((Slot)slot, guiContainer));
    }

    private Optional<IClickedIngredient<?>> getClickedIngredient(Slot slot, AbstractContainerScreen<?> guiContainer) {
        ItemStack stack = slot.m_7993_();
        return TypedIngredient.createTyped(this.registeredIngredients, VanillaTypes.ITEM_STACK, stack).map(typedIngredient -> {
            ImmutableRect2i slotArea = new ImmutableRect2i(guiContainer.getGuiLeft() + slot.f_40220_, guiContainer.getGuiTop() + slot.f_40221_, 16, 16);
            return new ClickedIngredient(typedIngredient, slotArea, false, false);
        });
    }
}

